﻿using System;
using System.Diagnostics.CodeAnalysis;
using System.Net.Http;
using System.Text.Json.Serialization;

namespace LoadProfiles;

[SuppressMessage("ReSharper", "StringLiteralTypo")]
public class Profile
{
    [JsonPropertyName("aim")] public string Aim { get; set; } = string.Empty;
    [JsonPropertyName("bio")] public string Bio { get; set; } = string.Empty;
    [JsonPropertyName("biography")] public string Biography { get; set; } = string.Empty;
    [JsonPropertyName("comments_count")] public int CommentsCount { get; set; }
    [JsonPropertyName("customtitle")] public int CustomTitle { get; set; }

    [JsonPropertyName("drink")] public string Drink { get; set; } = string.Empty;
    [JsonPropertyName("editor_status")] public string EditorStatus { get; set; } = string.Empty;

    [JsonPropertyName("favorite_stories_count")]
    public int FavoriteStoriesCount { get; set; }

    [JsonPropertyName("followed_stories_count")]
    public int FollowedStoriesCount { get; set; }

    [JsonPropertyName("followers_count")] public int FollowersCount { get; set; }
    [JsonPropertyName("followings_count")] public int FollowingsCount { get; set; }
    [JsonPropertyName("has_photo")] public int HasPhoto { get; set; }
    [JsonPropertyName("homepage")] public string Homepage { get; set; } = string.Empty;
    [JsonPropertyName("icq")] public object? Icq { get; set; } = string.Empty;
    [JsonPropertyName("joindate")] public string JoinDate { get; set; } = string.Empty;
    [JsonPropertyName("joindate_approx")] public string JoinDateApproximate { get; set; } = string.Empty;
    [JsonPropertyName("last_update_approx")] public string LastUpdateApproximate { get; set; } = string.Empty;
    [JsonPropertyName("location")] public string Location { get; set; } = string.Empty;
    [JsonPropertyName("options")] public int Options { get; set; }
    [JsonPropertyName("pets")] public string Pets { get; set; } = string.Empty;
    [JsonPropertyName("smoke")] public string Smoke { get; set; } = string.Empty;
    [JsonPropertyName("stories_count")] public int StoriesCount { get; set; }
    [JsonPropertyName("poems_count")] public int PoemsCount { get; set; }

    [JsonPropertyName("illustrations_count")]
    public int IllustrationsCount { get; set; }

    [JsonPropertyName("submissions_count")]
    public int SubmissionsCount { get; set; }

    [JsonPropertyName("userid")] public int UserId { get; set; }

    [JsonPropertyName("username")] public string UserName { get; set; } = string.Empty;
    [JsonPropertyName("userpic")] public string UserPic { get; set; } = string.Empty;
    [JsonPropertyName("usertitle")] public string UserTitle { get; set; } = string.Empty;

    [JsonPropertyName("favorites_count")] public object? FavoritesCount { get; set; }

    public string ProfileUrl => $"https://www.literotica.com/stories/memberpage.php?uid={UserId}";

    public string AllCounts => $"Stories: {StoriesCount} Poems: {PoemsCount} Illustrations: {IllustrationsCount} Submissions: {SubmissionsCount} Favorite Stories: {FavoriteStoriesCount} Followed Stories: {FollowedStoriesCount} Followers: {FollowersCount} Followings: {FollowingsCount}";

    public string Gender { get; set; } = string.Empty;

    public string Age { get; set; } = string.Empty;

    public string Weight { get; set; } = string.Empty;

    public string Height { get; set; } = string.Empty;

    public string Orientation { get; set; } = string.Empty;

    public string InterestedIn { get; set; } = string.Empty;

    public string Status { get; set; } = string.Empty;

    public string Fetishes { get; set; } = string.Empty;

    public string PetsFull { get; set; } = string.Empty;

    public string LastModified { get; set; } = string.Empty;

    public string UserNameAndId => $"{UserName} / {UserId}";
}