﻿using System;
using System.Diagnostics;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Navigation;

namespace LoadProfiles
{
    /// <summary>
    /// Interaction logic for ProfileControl.xaml
    /// </summary>
    public partial class ProfileControl : UserControl
    {
        public ProfileControl()
        {
            InitializeComponent();
        }

        private void Hyperlink_OnRequestNavigate(object sender, RequestNavigateEventArgs e)
        {
            Process.Start(new ProcessStartInfo(e.Uri.AbsoluteUri) { UseShellExecute = true });
            e.Handled = true;
        }

        private void MenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            if (CopyLinkMenuItem.CommandParameter is Uri commandParameter)
            {
                Clipboard.SetText(commandParameter.ToString());
            }
        }

        private void FrameworkContentElement_OnContextMenuOpening(object sender, ContextMenuEventArgs e)
        {
            if ((Mouse.DirectlyOver as Run)?.Parent is Hyperlink hyperlink)
            {
                //do whatever you want with the link now
                //e.g. set the command param on a named menu item  
                var item = CopyLinkMenuItem;
                item.CommandParameter = hyperlink.NavigateUri;
            }
        }
    }
}
